#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Pure DistractionMod01.fsh   by BadBadDog   
//https://www.shadertoy.com/view/dsGcWG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float Time = 0.0;
vec2 Shift = vec2(0.0);

vec4 Dots(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);

    vec2 uvmap = floor(uv*100.0*scale);
    vec4 mapshift = texture2D(texture0, vec2(0, uvmap.y/(100.0*scale) + Shift/100.0));

    uv.x += mapshift.x/(100.0*scale); 
    uvmap = floor(uv*100.0*scale);
    vec4 map = texture2D(texture0, uvmap/(100.0*scale) + Shift/100.0);


    vec2 point = (floor(uv*100.0*scale)+0.5)/(100.0*scale);
    ret.a = smoothstep(0.06*localscale, 0.0, distance(uv, point));
    ret.a += 0.5 * pow(smoothstep(0.05*localscale, 0.0, distance(uv, point)), 30.0);
    ret.a = pow(ret.a, 2.0+3.0*abs(sin(Time*1.0))) * (1.0-abs(sin(Time*1.0)));

    ret.r = ret.a * smoothstep(0.77, 0.78, map.r);
    ret.g = ret.a * smoothstep(0.77, 0.78, map.g);
    ret.b = ret.a * smoothstep(0.77, 0.78, map.b);
    
    ret.rgb += 2.0 * ret.r * vec3(pow(smoothstep(0.05*localscale, 0.0, distance(uv, point)), 10.0) * (1.0-abs(sin(Time*1.0))));
    ret.rgb += 2.0 * ret.g * vec3(pow(smoothstep(0.05*localscale, 0.0, distance(uv, point)), 10.0) * (1.0-abs(sin(Time*1.0))));
    ret.rgb += 2.0 * ret.b * vec3(pow(smoothstep(0.05*localscale, 0.0, distance(uv, point)), 10.0) * (1.0-abs(sin(Time*1.0))));

    return ret;
}


vec4 Panels(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);

    vec2 uvmap = floor(uv*100.0*scale);
    vec4 map = texture(texture0, uvmap/(100.0*scale) + Shift/100.0);

    ret.a = (abs(fract(uv.x*100.0*scale)-0.5)-0.5) * (abs(fract(uv.y*100.0*scale)-0.5)-0.5);
    ret.a = pow(ret.a, 0.1+0.9*abs(sin(Time*1.0))) * (1.0-abs(sin(Time*1.0)));

    ret.r = ret.a * smoothstep(0.7, 0.8, map.r);
    ret.g = ret.a * smoothstep(0.7, 0.8, map.g);
    ret.b = ret.a * smoothstep(0.7, 0.8, map.b);

    ret.r += 2.0 * pow(ret.a * smoothstep(0.7, 0.8, map.r), 2.0);
    ret.g += 2.0 * pow(ret.a * smoothstep(0.7, 0.8, map.g), 2.0);
    ret.b += 2.0 * pow(ret.a * smoothstep(0.7, 0.8, map.b), 2.0);

    return ret;
}


vec4 Lamps(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);

    vec2 uvmap = floor(uv*100.0*scale);
    vec4 map = texture(texture0, uvmap/(100.0*scale) + Shift/100.0);

    vec2 point = (floor(uv*100.0*scale)+0.5)/(100.0*scale);
    ret.a = smoothstep(0.06*localscale, 0.0, distance(uv, point));
    ret.a += 0.5 * pow(smoothstep(0.05*localscale, 0.0, distance(uv, point)), 30.0);
    ret.a = pow(ret.a, 2.0+3.0*abs(sin(Time*1.0))) * (1.0-abs(sin(Time*1.0)));


    ret.r = ret.a * smoothstep(0.77, 0.78, map.r);
    ret.g = ret.a * smoothstep(0.77, 0.78, map.g);
    ret.b = ret.a * smoothstep(0.77, 0.78, map.b);
    
    ret.rgb += 2.0 * ret.r * vec3(pow(smoothstep(0.05*localscale, 0.0, distance(uv, point)), 10.0) * (1.0-abs(sin(Time*1.0))));
    ret.rgb += 2.0 * ret.g * vec3(pow(smoothstep(0.05*localscale, 0.0, distance(uv, point)), 10.0) * (1.0-abs(sin(Time*1.0))));
    ret.rgb += 2.0 * ret.b * vec3(pow(smoothstep(0.05*localscale, 0.0, distance(uv, point)), 10.0) * (1.0-abs(sin(Time*1.0))));

    return ret;
}



vec4 Rings(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    vec2 center = vec2(0.5, 0.5);
    int d = int(abs(distance(uv, center)*100.0*scale-iTime));
    ret.rgb = vec3(float(d%2));
    return ret;
}

vec4 RingsRGB(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    
    vec2 center = vec2(0.5, 0.5);
    int d = int(abs(distance(uv, center)*100.0*scale-iTime));

    vec2 uvmap = floor(uv*100.0*scale);
    vec4 map = texture2D(texture0, vec2(float(d)/(200.0), (float(d)+Shift.x)/10.0));
    ret.rgb = vec3(float(d%2)) * smoothstep(0.4,0.7,map.rgb);
    return ret;
}

vec4 RingsCrazy(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    
    vec2 center = vec2(0.5, 0.5);
    int q = int(abs(distance(uv, center)*100.0*scale-iTime));
    float d = fract(abs(distance(uv, center)*100.0*scale+iTime));

    vec2 uvmap = floor(uv*100.0*scale);
    vec4 map = texture2D(texture0, vec2(float(d)/(200.0*Time), float(d)/30.0));
    ret.rgb = vec3(float(q%2)) * smoothstep(0.4,0.7,map.rgb);
    return ret;
}

vec4 HoopsRGB(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    
    vec2 center = vec2(0.5, 0.5);
    int q = int(abs(distance(uv, center)*100.0*scale-iTime)-0.5 + Shift);
    float d = abs(fract(abs(distance(uv, center)*100.0*scale-iTime))-0.5);

    vec2 uvmap = floor(uv*100.0*scale);
    vec4 map = texture2D(texture0, vec2(float(q)/(200.0), float(q)/30.0));
    ret.a = pow(d,1.6);
    ret.r = ret.a * smoothstep(0.51, 0.52, map.r);
    ret.g = ret.a * smoothstep(0.51, 0.52, map.g);
    ret.b = ret.a * smoothstep(0.51, 0.52, map.b);
    
    ret.rgb += 9.0 * ret.r * vec3(pow(smoothstep(0.0, 0.7*localscale, d), 10.0) * (1.0-abs(sin(Time*1.0))));
    ret.rgb += 9.0 * ret.g * vec3(pow(smoothstep(0.0, 0.7*localscale, d), 10.0) * (1.0-abs(sin(Time*1.0))));
    ret.rgb += 9.0 * ret.b * vec3(pow(smoothstep(0.0, 0.7*localscale, d), 10.0) * (1.0-abs(sin(Time*1.0))));
    
    return ret;
}


vec4 RingsBeat(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    
    vec2 center = vec2(0.5, 0.5);
    float d = distance(uv, center);
    vec2 r = uv-center;

    vec2 uvmap = r;
    vec4 map = texture2D(texture0, vec2(float(d)/(10.0+50.0*Time), float(d)/30.0));
    
    ret.rgb = map.rgb;

    return ret;
}

vec4 Rays(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    
    vec2 center = vec2(0.5, 0.5);
    float d = distance(uv, center);
    vec2 r = normalize(uv-center);
    r = r/10.0;
    vec4 map = texture2D(texture0, r+Shift/10.0);
    
    float speed_r = iTime*0.1;
    float fr = float(int(floor(abs(d+map.g-speed_r)*50.0*scale))%2);
    ret.r = 1.0 * pow(smoothstep(0.8+d*0.2, 1.0, map.r), 1.0) * fract((d-speed_r)*50.0*scale) * fr;
    float speed_g = iTime*0.3;
    float fg = float(int(floor(abs(d+map.b-speed_g)*50.0*scale))%2);
    ret.g = 1.0 * pow(smoothstep(0.8+d*0.2, 1.0, map.g), 1.0) * fract((d-speed_g)*50.0*scale) * fg;
    float speed_b = iTime*0.5;
    float fb = float(int(floor(abs(d+map.r-speed_b)*50.0*scale))%2);
    ret.b = 1.0 * pow(smoothstep(0.8+d*0.2, 1.0, map.b), 1.0) * fract((d-speed_b)*50.0*scale) * fb;

    ret.r += 0.05 * smoothstep(0.5, 1.0, map.r) * fr;
    ret.g += 0.05 * smoothstep(0.5, 1.0, map.g) * fg;
    ret.b += 0.05 * smoothstep(0.5, 1.0, map.b) * fb;

    return ret;
}





vec4 Kale(float scale, vec2 uv)
{
    vec2 center = vec2(0.5, 0.5);
    float d = distance(uv, center);
    uv -= center;
    uv.x *= 1.0+0.2*sin(1.0+iTime)*(1.0+d*2.0);
    uv.y *= 1.0+0.2*sin(1.0+iTime)*(1.0+d*2.0);

    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    

    vec4 map = texture2D(texture0, vec2(float(d)/(20.0+5.0*sin(iTime)), float(d)/10.0));

    vec2 point = (floor(uv*100.0*scale)+0.5)/(100.0*scale);
    float r = abs(cos(iTime))*0.08;
    ret.a = 0.9 * smoothstep(r*localscale-0.04, r*localscale, distance(uv, point)) * smoothstep(r*localscale+0.04, r*localscale, distance(uv, point));
    //ret.a = pow(ret.a, 2.0+3.0*abs(sin(Time*1.0))) * (1.0-abs(sin(Time*1.0)));


    ret.rgb = normalize(map.rgb) * pow(ret.a, 5.0);// * smoothstep(0.17, 0.18, map.r);
    
    ret.rgb += 2.0 * ret.a * vec3(pow(smoothstep(r*localscale-0.003, r*localscale, distance(uv, point)), 5.0) * pow(smoothstep(r*localscale+0.003, r*localscale, distance(uv, point)), 5.0) * (1.0-abs(sin(Time*1.0))));

    return ret;
}



vec4 Stars(float scale, vec2 uv)
{
    vec2 center = vec2(0.5, 0.5);
    float d = distance(uv, center);
    //uv -= center;
    //uv.x *= 1.0+0.2*sin(1.0+iTime)*(1.0+d*2.0);
    //uv.y *= 1.0+0.2*sin(1.0+iTime)*(1.0+d*2.0);

    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    

    vec4 map = texture2D(texture0, vec2(float(d)/(20.0+5.0*sin(iTime)), float(d)/10.0));

    vec2 point = (floor(uv*100.0*scale)+0.5)/(100.0*scale);
    float r = 0.11;//abs(cos(iTime))*0.08;
    ret.a = 2.0*smoothstep(r*localscale-0.04, r*localscale, distance(uv, point));
    //ret.a = pow(ret.a, 2.0+3.0*abs(sin(Time*1.0))) * (1.0-abs(sin(Time*1.0)));


    ret.rgb = normalize(map.rgb) * pow(ret.a, 3.0);// * smoothstep(0.17, 0.18, map.r);
    
    ret.rgb += 9.0 * ret.a * vec3(pow(smoothstep(r*localscale-0.04, r*localscale, distance(uv, point)), 3.0) * (1.0-abs(sin(Time*1.0))));

    return ret;
}



vec4 KaleRand(float scale, vec2 uv)
{
    vec2 center = vec2(0.5, 0.5);
    float d = distance(uv, center);
    uv -= center;
    uv.x *= 1.0+0.2*sin(1.0+iTime)*(1.0+d*2.0);
    uv.y *= 1.0+0.2*sin(1.0+iTime)*(1.0+d*2.0);

    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    

    vec4 map = texture2D(texture0, vec2(float(d)/(20.0+15.0*sin(iTime)), float(d)/10.0));

    vec2 point = (floor(uv*100.0*scale)+0.5)/(100.0*scale);
    float r = map.a*0.03;
    ret.a = 0.96 * smoothstep(r*localscale-0.03, r*localscale, distance(uv, point)) * smoothstep(r*localscale+0.03, r*localscale, distance(uv, point));
    //ret.a = pow(ret.a, 2.0+3.0*abs(sin(Time*1.0))) * (1.0-abs(sin(Time*1.0)));


    ret.rgb = normalize(map.rgb) * pow(ret.a, 9.0);// * smoothstep(0.17, 0.18, map.r);
    
    ret.rgb += 1.0 * ret.a * vec3(pow(smoothstep(r*localscale-0.003, r*localscale, distance(uv, point)), 5.0) * pow(smoothstep(r*localscale+0.003, r*localscale, distance(uv, point)), 5.0) * (1.0-abs(sin(Time*1.0))));

    return ret;
}




vec4 Ring(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    
    vec2 center = vec2(0.5, 0.5);
    int q = int(abs(distance(uv, center)*100.0*scale-iTime)-0.5 + Shift);
    float d = abs(fract(abs(distance(uv, center)*100.0*scale-iTime))-0.5);

    vec2 uvmap = floor(uv*100.0*scale);
    vec4 map = texture2D(texture0, vec2(float(q)/(200.0), float(q)/30.0));
    float r = 0.2;
    ret.a = smoothstep(r-0.05, r, distance(uv, center)) * smoothstep(r+0.05, r, distance(uv, center));
    ret.r = 0.5 * pow(ret.a, 3.0);// * smoothstep(0.51, 0.52, map.r);
    //ret.g = ret.a * smoothstep(0.51, 0.52, map.g);
    //ret.b = ret.a * smoothstep(0.51, 0.52, map.b);
    
    //ret.rgb += 9.0 * ret.r * vec3(pow(smoothstep(0.0, 0.7*localscale, d), 10.0) * (1.0-abs(sin(Time*1.0))));
    //ret.rgb += 9.0 * ret.g * vec3(pow(smoothstep(0.0, 0.7*localscale, d), 10.0) * (1.0-abs(sin(Time*1.0))));
    //ret.rgb += 9.0 * ret.b * vec3(pow(smoothstep(0.0, 0.7*localscale, d), 10.0) * (1.0-abs(sin(Time*1.0))));
    
    return ret;

}



vec4 Disco(float scale, vec2 uv)
{
    vec4 ret = vec4(0);
    float localscale = 1.0/(scale*10.0);
    
    vec2 center = vec2(0.5, 0.5);
    int q = int(abs(distance(uv, center)*100.0*scale-iTime)-0.5 + Shift);
    float d = abs(fract(abs(distance(uv, center)*100.0*scale-iTime*0.1))-0.5);

    vec2 uvmap = floor(uv*100.0*scale);
    vec4 map = texture2D(texture0, vec2(float(q)/(200.0), float(q)/30.0));
    float r = 0.1;
    ret.a = smoothstep(r+0.002, r, distance(uv, center)) * smoothstep(r*0.1, r*0.1+0.002, distance(uv, center));
    ret.a *= smoothstep(r*0.9, r*0.9-0.002, distance(uv, center)) + smoothstep(r*0.92, r*0.91+0.002, distance(uv, center));

    vec4 text = texture2D(texture0, uv);

    ret.rgb = ret.a * smoothstep(0.51, 0.52, vec3(1,0,1));
    
    ret.rgb -= 0.5*text.r * smoothstep(r*0.6+0.02, r*0.6, distance(uv, center)) * smoothstep(r*0.3, r*0.3+0.02, distance(uv, center));

    float rides = smoothstep(-0.9, -0.8, sin(distance(uv, center)*130.0)) * smoothstep(r*1.3, r*1.3+0.002, distance(uv, center));
    rides *= sin(d*160.0);
    //rides += smoothstep(0.01,0.0,sin((distance(uv, center)-iTime*0.02)*200.0)) * smoothstep(r*1.0, r*1.0+0.002, distance(uv, center)) * smoothstep(r*1.3+0.002, r*1.3, distance(uv, center));
    
    float hl = smoothstep(-0.3, 0.0, normalize(uv-center).x) * smoothstep(0.3, 0.0, normalize(uv-center).x);
    ret += rides * (0.1 + 0.2*pow(hl,2.0) + 0.3*pow(hl,9.0));
    
    return ret;

}
















//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord/iResolution.xy;


    Time = fract((iTime*10.0)/6.28);
    Shift = vec2(floor((iTime*10.0)/6.28), floor((iTime*10.0)/6.28));

    vec4 col = vec4(0.0);
    
    //vec4 col = Dots(0.2, uv);
    //col = Panels(0.2, uv);
    //vec4 col = Lamps(0.2, uv);
    //vec4 col = Rings(0.1, uv);
    //vec4 col = RingsRGB(0.1, uv);
    //vec4 col = HoopsRGB(0.1, uv);
    //vec4 col = Rays(0.1, uv);
    col = Kale(0.1, uv);
    //col *= Kale(0.2, uv);
    //col *= Kale(0.4, uv);
    //col = HoopsRGB(0.1, uv);
    //col = Stars(0.2, uv);
    //col = KaleRand(0.2, uv);
    //col = Ring(0.1, uv);
    //col = Disco(0.1, uv);
    


    fragColor = col;

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

